<?php
/*
	Plugin Name: Paytrail-verkkomaksutoiminto
	Plugin URI: https://www.laskuhari.fi/paytrail-woocommerce-verkkomaksu
	Description: Lisää Paytrailin verkkomaksutoiminnot WooCommercen kassasivulle
	Version: 1.0
	Author: Datahari Solutions
	Author URI: https://www.datahari.fi
	License:  GPL-2.0+
 	License URI:  http://www.gnu.org/licenses/gpl-2.0.txt

 	Modified from Paga Woocommerce E-Pay plugin
 	(https://wordpress.org/plugins/paga-woocommerce/)
 	Original author: Pagatech Limited
 	Modification date: 2016/10/10
*/
if ( ! defined( 'ABSPATH' ) )
	exit;

add_action('plugins_loaded', 'tbz_wc_dhpaytrail_init', 0);

function tbz_wc_dhpaytrail_init() {

	if ( ! class_exists( 'WC_Payment_Gateway' ) ) return;

	/**
 	 * Gateway class
 	 */
	class WC_Tbz_dhpaytrail_Gateway extends WC_Payment_Gateway {

		public function __construct(){

			$this->order_button_text  = __( 'Siirry maksamaan', 'woocommerce-gateway-dhpaytrail' );
			$this->id 					= 'tbz_dhpaytrail_gateway';
			$this->has_fields 			= true;
        	$this->method_title     	= 'Paytrail';
        	$this->method_description  	= 'Paytrailin maksunvälityspalvelu';

			// Load the form fields.
			$this->init_form_fields();

			// Load the settings.
			$this->init_settings();

			// Define user set variables
			$this->title              = $this->get_option( 'title' );
			$this->description        = $this->get_option( 'description' );
			$this->show_banner  	  = $this->get_option( 'show_banner' );
			$this->show_logo  		  = $this->get_option( 'show_logo' );

			$this->merchant_id        = $this->get_option( 'merchant_id' );
			$this->merchant_secret    = $this->get_option( 'merchant_secret' );

			if($this->show_logo == 'yes') {
    			$this->icon 				= apply_filters('woocommerce_dhpaytrail_icon', plugins_url( 'assets/paytrail-logo.png' , __FILE__ ) );
			}

			//Actions
			add_action('woocommerce_receipt_tbz_dhpaytrail_gateway', array($this, 'receipt_page'));
			add_action( 'woocommerce_update_options_payment_gateways_' . $this->id, array( $this, 'process_admin_options' ) );

			// Payment listener/API hook
			add_action( 'woocommerce_api_wc_tbz_dhpaytrail_gateway', array( $this, 'check_dhpaytrail_response' ) );
		}

        /**
         * Admin Panel Options
         **/
        public function admin_options(){
        	echo '<p><a href="https://www.laskuhari.fi/?ref=paytrail_woocommerce" target="_blank" id="dh-paytrail-ad-link"><img src="https://www.laskuhari.fi/dh-paytrail-ad.png" id="dh-paytrail-ad-img" /></a></p>
        	<script src="https://www.laskuhari.fi/dh-paytrail-ad.js" type="text/javascript"></script>';
            echo '<h3>Paytrail-integraation asetukset</h3>';
            echo '<p>Tässä voit määrittää asetukset Paytrail-integraatiota varten.</p>';
            echo '<table class="form-table">';
            $this->generate_settings_html();
            echo '</table>';
        }


	    /**
	     * Initialise Gateway Settings Form Fields
	    **/

		function init_form_fields(){

			$this->form_fields = array(
				'enabled' => array(
					'title'       => __( 'Käytössä', 'woocommerce' ),
					'label'       => __( 'Ota käyttöön Paytrail-maksutapa', 'woocommerce' ),
					'type'        => 'checkbox',
					'description' => '',
					'default'     => 'no'
				),
				'title' => array(
					'title'       => __( 'Otsikko', 'woocommerce' ),
					'type'        => 'text',
					'description' => __( 'Tämä näkyy maksutavan nimenä asiakkaalle', 'woocommerce' ),
					'default'     => __( 'Verkkomaksu', 'woocommerce' ),
					'desc_tip'    => true,
				),
				'description' => array(
					'title'       => __( 'Kuvaus', 'woocommerce' ),
					'type'        => 'textarea',
					'description' => __( 'Kuvaus, joka näytetään maksutavan yhteydessä', 'woocommerce' ),
					'default'     => __( 'Maksa tilauksesi verkkopankissa tai luottokortilla', 'woocommerce' ),
					'desc_tip'    => true,
				),
				'show_banner' => array(
					'title'       		=> 'Banneri',
					'type'        		=> 'checkbox',
					'label'       		=> 'Näytä maksutapabanneri',
					'default'     		=> 'yes',
					'description' 		=> 'Näytä maksutapabanneri maksutavan valinnan yhteydessä',
				),
				'show_logo' => array(
					'title'       		=> 'Logo',
					'type'        		=> 'checkbox',
					'label'       		=> 'Näytä Paytrail-logo',
					'default'     		=> 'yes',
					'description' 		=> 'Näytä Paytrailin logo maksutavan valinnan yhteydessä',
				),
				'merchant_id' => array(
					'title'       => __( 'Kauppiastunnus', 'woocommerce' ),
					'type'        => 'text',
					'description' => __( 'Kauppiastunnus Paytrail-palveluun', 'woocommerce' ),
					'default'     => __( '', 'woocommerce' ),
					'desc_tip'    => true,
				),
				'merchant_secret' => array(
					'title'       => __( 'Kauppiasvarmenne', 'woocommerce' ),
					'type'        => 'text',
					'description' => __( 'Kauppiasvarmenne Paytrail-palveluun', 'woocommerce' ),
					'default'     => __( '', 'woocommerce' ),
					'desc_tip'    => true,
				)
			);
		}


	    /**
		 * Generate the dhpaytrail Payment button link
	    **/
	    function generate_dhpaytrail_form( $order_id ) {

			$order 					= wc_get_order( $order_id );

			if($order->get_order_currency() != "EUR") {
				wc_add_notice( "Verkkomaksua ei voi käyttää, mikäli valuuttana ei ole Euro" , 'error' );
				return;
			}

			$customer 				= $order->get_address('billing');
			$description       		= "Maksu tilaukselle $order_id (". get_bloginfo('name').")";
			$return_url 			= WC()->api_request_url( 'WC_Tbz_dhpaytrail_Gateway' );
			$order_total			= $order->get_total();
			$order_id				= $order->id;

			require_once(plugin_dir_path(__FILE__)."/Paytrail_Module_Rest.php");

			// An object is created to model all payment return addresses
			$urlset = new Paytrail_Module_Rest_Urlset(
			    $return_url, // return address for successful payment
			    $return_url, // return address for failed payment
			    $return_url,  // address for payment confirmation from Paytrail server
			    ""  // pending url not in use
			);

			// Payment creation
			$orderNumber = $order_id;                     // Use distinguished order number
			$price = $order_total;                        // Total  (incl. VAT)
			$payment = new Paytrail_Module_Rest_Payment_S1($orderNumber, $urlset, $price);

			// Changing payment default settings
			// Changing payment method selection page language into English here
			// The default language is Finnish. See other options from PHP class
			$payment->setLocale("fi_FI");

			// Sending payment to Paytrail service and handling possible errors
			$module = new Paytrail_Module_Rest($this->merchant_id, $this->merchant_secret);
			try {
			    $result = $module->processPayment($payment);
			}
			catch (Paytrail_Exception $e) {
			    // processing the error
			    // Error description available $e->getMessage()
				if($order->get_order_currency() != "EUR") {
					wc_add_notice( "Virhe: Error in creating payment to Paytrail service" , 'error' );
					return;
				}
			}

			// Using the URL Paytrail returned for the desired payment method
			// User is immediately directed to the received address
			header("Location: {$result->getUrl()}");
			exit;
			return;
		}


	    /**
	     * Process the payment and return the result
	    **/
		function process_payment( $order_id ) {

			$order = wc_get_order( $order_id );

	        return array(
	        	'result' 	=> 'success',
				'redirect'	=> $order->get_checkout_payment_url( true )
	        );

		}

		public function payment_fields(){
			echo $this->description;
			if($this->show_banner == 'yes') {
				echo '<br /><img src="'.plugins_url( 'assets/payment-methods.png' , __FILE__ ).'" style="max-height: 261px; width: 100%; height: auto; max-width: 400px; float: none;" />';
			}
		}

	    /**
	     * Output for the order received page.
	    **/
		function receipt_page( $order ) {
			echo $this->generate_dhpaytrail_form( $order );
		}


		/**
		 * Process Payment!
		**/
		function check_dhpaytrail_response( $posted ){
			print_r($_GET);

			$order_id 		= (int)$_GET['ORDER_NUMBER'];
            $order 			= wc_get_order($order_id);

            //after payment hook
            do_action('tbz_dhpaytrail_woo_after_payment', $_POST, $order );

			require_once(plugin_dir_path(__FILE__)."/Paytrail_Module_Rest.php");

            $module = new Paytrail_Module_Rest($this->merchant_id, $this->merchant_secret);
            if ($module->confirmPayment($_GET["ORDER_NUMBER"], $_GET["TIMESTAMP"], $_GET["PAID"], $_GET["METHOD"], $_GET["RETURN_AUTHCODE"])) {
                // Payment receipt is valid
                // If needed, the used payment method can be found from the variable $_GET["METHOD"]
                // and order number for the payment from the variable $_GET["ORDER_NUMBER"]
				$order->update_status( 'processing', 'Maksu vahvistettu' );

                $order->add_order_note( 'Maksettu verkkomaksuna');

				// Reduce stock levels
				$order->reduce_order_stock();

				// Empty cart
				WC()->cart->empty_cart();
            }
            else {
            	// Payment receipt was not valid, possible payment fraud attempt
				wc_add_notice( 'Maksu epäonnistui tai peruttiin', 'error' );
            }
               
			$redirect_url = esc_url( $this->get_return_url( $order ) );
		    wp_redirect( $redirect_url );
		    exit;
        }
	}
	/**
 	* Add the Gateway to WooCommerce
 	**/
	function tbz_wc_add_dhpaytrail_gateway($methods) {
		$methods[] = 'WC_Tbz_dhpaytrail_Gateway';
		return $methods;
	}
	add_filter('woocommerce_payment_gateways', 'tbz_wc_add_dhpaytrail_gateway' );


	/**
	* Add Settings link to the plugin entry in the plugins menu for WC below 2.1
	**/
	if ( version_compare( WOOCOMMERCE_VERSION, "2.1" ) <= 0 ) {

		add_filter('plugin_action_links', 'tbz_dhpaytrail_plugin_action_links', 10, 2);

		function tbz_dhpaytrail_plugin_action_links($links, $file) {
		    static $this_plugin;

		    if (!$this_plugin) {
		        $this_plugin = plugin_basename(__FILE__);
		    }

		    if ($file == $this_plugin) {
		        $settings_link = '<a href="' . get_bloginfo('wpurl') . '/wp-admin/admin.php?page=woocommerce_settings&tab=payment_gateways&section=WC_Tbz_dhpaytrail_Gateway">Asetukset</a>';
		        array_unshift($links, $settings_link);
		    }
		    return $links;
		}
	}
	/**
	* Add Settings link to the plugin entry in the plugins menu for WC 2.1 and above
	**/
	else{
		add_filter('plugin_action_links', 'tbz_dhpaytrail_plugin_action_links', 10, 2);

		function tbz_dhpaytrail_plugin_action_links($links, $file) {
		    static $this_plugin;

		    if (!$this_plugin) {
		        $this_plugin = plugin_basename(__FILE__);
		    }

		    if ($file == $this_plugin) {
		        $settings_link = '<a href="' . get_bloginfo('wpurl') . '/wp-admin/admin.php?page=wc-settings&tab=checkout&section=wc_tbz_dhpaytrail_gateway">Asetukset</a>';
		        array_unshift($links, $settings_link);
		    }
		    return $links;
		}
	}

	/**
 	* Display the testmode notice
 	**/
	function tbz_wc_dhpaytrail_testmode_notice(){
		$tbz_dhpaytrail_settings = get_option( 'woocommerce_tbz_dhpaytrail_gateway_settings' );

		$dhpaytrail_test_mode = $tbz_dhpaytrail_settings['testmode'];

		if ( 'yes' == $dhpaytrail_test_mode ) {

		$settings_link = get_bloginfo('wpurl') . '/wp-admin/admin.php?page=wc-settings&tab=checkout&section=wc_tbz_dhpaytrail_gateway';

	    ?>
		    <div class="update-nag">
		        Verkkomaksutoiminto on testaustilassa. Poista testaustila käytöstä <a href="<?php echo $settings_link; ?>">täällä</a>
		    </div>
	    <?php
		}
	}
	add_action( 'admin_notices', 'tbz_wc_dhpaytrail_testmode_notice' );
}